/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

import ibm.nways.jdm.mib.MibObject;
import java.util.Enumeration;
import java.util.Vector;

public class MibTrap {
    private String name;
    private String enterprise;
    private String enterpriseOid;
    private String description;
    private int specificId;
    private int genericId = 6;
    private Vector variableList;
    private final String newline = System.getProperty("line.separator");
    private static char QUOTE = (char)34;

    public MibTrap(String string, String string2, String string3) {
        this.name = string;
        this.enterprise = string2;
        try {
            this.specificId = Integer.parseInt(string3);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.specificId = -1;
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEnterpriseName() {
        return this.enterprise;
    }

    public int getSpecificId() {
        return this.specificId;
    }

    public int getGenericId() {
        return this.genericId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string.charAt(0) == QUOTE && string.charAt(string.length() - 1) == QUOTE) {
            this.description = string.substring(1, string.length() - 1);
            return;
        }
        this.description = string;
    }

    public void setEnterpriseOid(String string) {
        this.enterpriseOid = string;
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid;
    }

    public void addVariable(Object object) {
        if (this.variableList == null) {
            this.variableList = new Vector();
        }
        this.variableList.addElement(object);
    }

    public Vector getVariableList() {
        return this.variableList;
    }

    public void setVariableList(Vector vector) {
        this.variableList = vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Trap:  ");
        try {
            stringBuffer.append(this.name);
            stringBuffer.append(", enterprise= ");
            stringBuffer.append(this.enterprise);
            stringBuffer.append(" (");
            stringBuffer.append(this.enterpriseOid);
            stringBuffer.append(")");
            stringBuffer.append(", specificID= ");
            stringBuffer.append(this.specificId);
            stringBuffer.append(this.newline);
            stringBuffer.append(this.description);
            stringBuffer.append(this.newline);
            if (!this.variableList.isEmpty()) {
                stringBuffer.append("  Variables:  ");
                Enumeration enumeration = this.variableList.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e instanceof MibObject) {
                        MibObject mibObject = (MibObject)e;
                        stringBuffer.append(mibObject.name);
                        stringBuffer.append(" (");
                        stringBuffer.append(mibObject.id.getValue());
                        stringBuffer.append(")");
                    } else {
                        stringBuffer.append(e.toString());
                    }
                    stringBuffer.append(this.newline);
                    if (!enumeration.hasMoreElements()) continue;
                    stringBuffer.append("              ");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringBuffer.append(this.newline);
        return stringBuffer.toString();
    }
}

